<?php
/* --------------------------------------------------------------
   ParcelServiceService.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Interfaces;

use Gambio\Admin\ParcelService\Exceptions\ParcelServiceNotFoundException;

/**
 * Interface ParcelServiceService
 *
 * @package Gambio\Admin\ParcelService\Interfaces
 */
interface ParcelServiceService
{
    /**
     * Returns a list of all parcel services.
     *
     * @param ParcelServiceSqlCriteria   $criteria
     * @param ParcelServiceSqlPagination $pagination
     *
     * @return ParcelServices
     */
    public function getAllParcelServices(
        ParcelServiceSqlCriteria $criteria,
        ParcelServiceSqlPagination $pagination
    ): ParcelServices;
    
    
    /**
     * Returns the total number of parcel services.
     *
     * @param ParcelServiceSqlCriteria $criteria
     *
     * @return int
     */
    public function getTotalCountOfParcelServices(ParcelServiceSqlCriteria $criteria): int;
    
    
    /**
     * Returns the parcel service with the provided ID.
     *
     * @param ParcelServiceId $id
     *
     * @return ParcelService
     *
     * @throws ParcelServiceNotFoundException
     */
    public function getParcelServiceById(ParcelServiceId $id): ParcelService;
    
    
    /**
     * Stores the provided parcel service.
     *
     * @param ParcelService $parcelService
     *
     * @return ParcelServiceId
     */
    public function storeParcelService(ParcelService $parcelService): ParcelServiceId;
    
    
    /**
     * Stores all provided parcel services.
     *
     * @param ParcelServices $parcelServices
     *
     * @return ParcelServiceIds
     */
    public function storeParcelServices(ParcelServices $parcelServices): ParcelServiceIds;
    
    
    /**
     * Deletes the parcel service with the provided ID.
     *
     * @param ParcelServiceId $id
     */
    public function deleteParcelService(ParcelServiceId $id): void;
    
    
    /**
     * Deletes multiple parcel services by the provided Ids.
     *
     * @param ParcelServiceIds $ids
     */
    public function deleteParcelServices(ParcelServiceIds $ids): void;
}